package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.JLabel;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Font;
import java.awt.Color;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.ImageIcon;
import net.miginfocom.swing.MigLayout;
import javax.swing.JTextArea;

public class MainAppWindow {

	private JFrame frmLikeARolling;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel southPanel;
	private JPanel eastPanel;
	private JButton btnStart;
	private JLabel lblLegendarySongs;
	private JSplitPane splitPane;
	private JScrollPane leftScrollPane;
	private JScrollPane rightScrollPane;
	private JLabel label;
	private JLabel lblYear;
	private JLabel lblYearValue;
	private JButton btnSave;
	private JTextArea textArea;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainAppWindow window = new MainAppWindow();
					window.frmLikeARolling.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainAppWindow() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmLikeARolling = new JFrame();
		frmLikeARolling.setTitle("Like a Rolling Stone");
		frmLikeARolling.setBounds(100, 100, 450, 300);
		frmLikeARolling.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmLikeARolling.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmLikeARolling.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmLikeARolling.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmLikeARolling.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmLikeARolling.getContentPane().add(getSplitPane_1(), BorderLayout.CENTER);
	}

	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			northPanel.add(getLblLegendarySongs());
			northPanel.add(getBtnStart());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setVisible(false);
		}
		return westPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setVisible(false);
		}
		return southPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setLayout(new MigLayout("", "[]", "[][][grow][]"));
			eastPanel.add(getLblYear(), "cell 0 0");
			eastPanel.add(getLblYearValue(), "cell 0 1");
			eastPanel.add(getBtnSave(), "cell 0 3");
			eastPanel.setVisible(false);
		}
		return eastPanel;
	}
	private JButton getBtnStart() {
		if (btnStart == null) {
			btnStart = new JButton("Start");
			btnStart.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					lblLegendarySongs.setVisible(true);
					btnStart.setVisible(false);
//					centerPanel.setVisible(true);
					eastPanel.setVisible(true);
					westPanel.setVisible(true);
					southPanel.setVisible(true);
					splitPane.setVisible(true);
				}
			});
		}
		return btnStart;
	}
	private JLabel getLblLegendarySongs() {
		if (lblLegendarySongs == null) {
			lblLegendarySongs = new JLabel("Legendary songs");
			lblLegendarySongs.setForeground(new Color(0, 0, 255));
			lblLegendarySongs.setFont(new Font("Tahoma", Font.BOLD, 13));
			lblLegendarySongs.setVisible(false);
		}
		return lblLegendarySongs;
	}
	private JSplitPane getSplitPane_1() {
		if (splitPane == null) {
			splitPane = new JSplitPane();
			splitPane.setVisible(false);
			splitPane.setLeftComponent(getLeftScrollPane());
			splitPane.setRightComponent(getScrollPane_1());
			splitPane.setDividerLocation(100);
			splitPane.setOneTouchExpandable(true);
			splitPane.setDividerSize(8);
		}
		return splitPane;
	}
	private JScrollPane getLeftScrollPane() {
		if (leftScrollPane == null) {
			leftScrollPane = new JScrollPane();
			leftScrollPane.setViewportView(getLabel());
		}
		return leftScrollPane;
	}
	private JScrollPane getScrollPane_1() {
		if (rightScrollPane == null) {
			rightScrollPane = new JScrollPane();
			rightScrollPane.setViewportView(getTextArea());
		}
		return rightScrollPane;
	}
	private JLabel getLabel() {
		if (label == null) {
			label = new JLabel("");
			label.setIcon(new ImageIcon("C:\\Documents and Settings\\Korisnik\\My Documents\\Like a Rolling Stone, 11.12.2015, 16-18\\resources\\Bob Dylan.jpg"));
		}
		return label;
	}
	private JLabel getLblYear() {
		if (lblYear == null) {
			lblYear = new JLabel("Year");
		}
		return lblYear;
	}
	private JLabel getLblYearValue() {
		if (lblYearValue == null) {
			lblYearValue = new JLabel("");
		}
		return lblYearValue;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
		}
		return btnSave;
	}
	private JTextArea getTextArea() {
		if (textArea == null) {
			textArea = new JTextArea();
			textArea.setWrapStyleWord(true);
			textArea.setLineWrap(true);
		}
		return textArea;
	}
}
